;    File              : $Workfile: GEXTEND.ASM$
;
;    Description       : GEM VDI extended functions (bezier) support
;
;    Original Author   : ?
;
;    Last Edited By    : $Author: AWIGHTMA$
;
;-----------------------------------------------------------------------;
;       Copyright 1999, Caldera Thin Clients, Inc.                      ;
;       This software is licenced under the GNU Public License.         ;
;       Please see LICENSE.TXT for further information.                 ;
;                                                                       ;
;                  Historical Copyright                                 ;
;	Copyright (C) 1976-1992 Digital Research Inc. All rights	;
;	reserved. The Software Code contained in this listing is	;
;	proprietary to Digital Research Inc., Monterey,			;
;	California, and is covered by U.S. and other copyright		;
;	protection. Unauthorized copying, adaption, distribution,	;
;	use or display is prohibited and may be subject to civil	;
;	and criminal penalties. Disclosure to others is			;
;	prohibited. For the terms and conditions of software use,	;
;	refer to the appropriate Digital Research Licence		;
;	Agreement.							;
;-----------------------------------------------------------------------;
;
;    *** Current Edit History ***
;    *** End of Current Edit History ***
;
;    $Log: $
;    GEXTEND.ASM 1.1 92/07/23 18:06:55 AWIGHTMA
;    ;	Use near calls to bezier code - atw
;    
;
;    ENDLOG
include	equates.inc		; contains equates, definitions and externals

CODE 	ends			; close the small code segment
DATA	segment
		public	COMPACT? ; Create data segment to get label
COMPACT?	label	word
DATA	ends
CODE	segment			; open small code segment again

		public	gext_check
		public	_gext_dcall
		public	_gext_allmem
		public	_gext_relmem
		public	_mult

		extrn	_bez_call:near
		extrn	driver:near
		extrn	transform_ptsout:near

bezenabled	dw	0		; non 0 if BEZ enable escape rec'd

gext_check:
		cmp	ax, 5		; escape?
		jne	gext_notesc	; if so then
		cmp	word ptr 10[si], 99 ; escape 99?
		je	gext_gotone	; have a Bezier escape
gext_notesc:
		cmp	ax, 11		; gdp ?
		jne	gext_notgdp	; if so => maybe something to do
		cmp	word ptr 10[si], 12 ; non-filled Bezier?
		je	gext_gotone	; go do it if so
		cmp	word ptr 10[si], 13 ; filled Bezier or on/off?
		jne	gext_notone	; if not then nothing more to do
		mov	ax, word ptr 2[si] ; ax = PTSIN count
		mov	bezenabled, ax	; if 0 => disable Beziers, else enable
		jmp short gext_gotone	; go do Bezier stuff

gext_notgdp:
		cmp	ax, 6		; pline ?
		je	gext_maybe	; if so => maybe do unfilled Bezier
		cmp	ax, 9		; fillarea ?
		jne	gext_notone	; if not then exit
gext_maybe:
		cmp	bezenabled, 0	; Bezier enable escape received ?
		jne	gext_gotone	; non 0 then do a Bezier
		mov	word ptr 6[si], 0 ; fix pline and fillarea calls
		jmp short gext_notone	; not an extended call
gext_gotone:
		push	ds		; save ds
		push	app_buff_size	; application buffer size
		push	app_buff_seg	; application buffer address
		push	app_buff_off	; far pointer
		mov	ax, seg contrl	; pass far pointer to parmblock
		push	ax
		mov	ax, offset contrl
		push	ax
		
		mov	ax, seg COMPACT? ; set up data segment for "C" code
		mov	ds, ax		; DS -> data segment
		call	_bez_call
		add	sp, 10		; pop parms off stack
		pop	ds

		stc			; indicate processing complete
		ret
gext_notone:
		clc			; indicate needs driver call still
		ret

_gext_dcall:
		push	bp		; save argument pointer
		mov	bp, sp		; bp -> stack
		push	ds		; save ds

		lds	si, 4[bp]	; ds:si = parameter block
		mov	ax, cs		; GDOSs copy is in code segemnt
		mov	es, ax		; es:di = new parameter block 
		mov	di, offset contrl
		mov	cx, 10		; move five long pointers
	rep	movsw
		call	driver		; do the driver call
		call	transform_ptsout ; who knows, maybe so
		pop	ds
		pop	bp		; restore bp
		ret

_gext_allmem:	; nparaalloc = gext_allomem(nparareq, &segment)
		push	bp		; save argument pointer
		mov	bp, sp		; bp -> stack

		mov	bx, 4[bp]	; bx = # paragraphs requested
		mov	ah, 048h	; allocate memory
		int	021h		; do it
		jnc	allsuc		; if no CY then got it all
		mov	ah, 048h	; allocate memory
		int	021h		; otherwise allocate available mem
		jnc	allsuc		; if a problem =>
		sub	ax, ax		; force segment to 0
		mov	bx, ax		; and allocation amount
allsuc:		
		les	di, 6[bp]	; es:di = segment address
		mov	es:[di], ax	; return it to caller
		mov	ax, bx		; return # paragraphs allocated
		pop	bp
		ret

_gext_relmem:	; status = gext_relmem(segment)
		push	bp		; save argument pointer
		mov	bp, sp		; bp -> stack

		mov	es, 4[bp]	; es = segment to be released
		mov	ah, 049h	; free allocate memory
		int	021h		; do it
		jc	relerr		; if no CY then
		sub	ax, ax		; return 0 since successful
relerr:
		pop	bp
		ret

_mult:	; long mult(int a, int b)  -> returns a * b as long in dx:ax
		push	bp
		mov	bp, sp
		mov	ax, 4[bp]
		mul	word ptr 6[bp]
		pop	bp
		ret

CODE	ends

		end
