;    File              : $Workfile: INIFILE.ASM$
;
;    Description       : GEM font support
;
;    Original Author   : ?
;
;    Last Edited By    : $Author: AWIGHTMA$
;
;-----------------------------------------------------------------------;
;       Copyright 1999, Caldera Thin Clients, Inc.                      ;
;       This software is licenced under the GNU Public License.         ;
;       Please see LICENSE.TXT for further information.                 ;
;                                                                       ;
;                  Historical Copyright                                 ;
;	Copyright (C) 1976-1992 Digital Research Inc. All rights	;
;	reserved. The Software Code contained in this listing is	;
;	proprietary to Digital Research Inc., Monterey,			;
;	California, and is covered by U.S. and other copyright		;
;	protection. Unauthorized copying, adaption, distribution,	;
;	use or display is prohibited and may be subject to civil	;
;	and criminal penalties. Disclosure to others is			;
;	prohibited. For the terms and conditions of software use,	;
;	refer to the appropriate Digital Research Licence		;
;	Agreement.							;
;-----------------------------------------------------------------------;
;
;    *** Current Edit History ***
;    *** End of Current Edit History ***
;
;    $Log: $
;    INIFILE.ASM 1.1 92/07/23 18:07:05 AWIGHTMA
;    ; 08Nov91	K.H	Move fatal_msg to GDOSMSG.A86
;    ; 01Dec91	K.H	Support double byte character set.
;    
;
;    ENDLOG
include	equates.inc		; contains equates, definitions and externals

; Public entry points.
		public	parse_inifile

if DBCS
		extrn	dbcs_lead:near
		extrn	check_dbcs:near
endif


ini_fname	db	'VIEWMAX.INI',0
ini_pathname	db	'VIEWMAX.INI',0
		db	128 dup (?)

cfg_variable	db	'DRDOSCFG=',0
cfg_varlen	dw	9

drivers_sect	db	'[DRIVERS]',0
drivers_len	dw	9
curdrv_item	db	'CURRENTDRV'
curdrv_len	dw	10
drvn_item	db	'DRIVER',0,0,0
drvn_len	dw	6
mtype_item	db	'MOUSETYPE',0
mtype_len	dw	9
mport_item	db	'MOUSEPORT',0
mport_len	dw	9
patch_item	db	'VIDPATCH',0
patch_len	dw	8

ini_handle	dw	0
file_size	dw	0
file_seg	dw	0
buf_ptr		dw	0
section_ptr	dw	0

near_line	db	256 dup (?)

;**************************************************************************

parse_inifile:
	
		push	ds
		push	es
		cld
		
		mov	ax,cs
		mov	ds,ax
		mov	es,ax
	
	; read the ini file into memory
		call	build_filename

		call	open_file
		call	get_file_size
		call	allocate_memory
		call	read_file
		call	close_file
	
	; look for the [Drivers] section
		mov	si,offset drivers_sect
		mov	cx,drivers_len
		call	find_section
	
	; look for the CurrentDrv item
		mov	si,offset curdrv_item
		mov	cx,curdrv_len
		call	find_item
		
	; near_line now contains the CurrentDrv item	
		mov	si,offset near_line
		call	find_item_value
	
	; construct the DRIVERn item name
		mov	di,offset drvn_item
		mov	cx,drvn_len
		add	di,cx
		movsb
	
	; find the DRIVERn item
		mov	si,offset drvn_item
		inc	cx
		call	find_item
		mov	si,offset near_line
		call	find_item_value
		
	; copy the new driver name to sd_name
		mov	di,offset sd_name
pi_loop1:
		lodsb
		cmp	al,33
		jb	pi_break1
		stosb
		jmp short pi_loop1
pi_break1:		
		sub	al,al
		stosb	

	; find the MouseType item
		mov	si,offset mtype_item
		mov	cx,mtype_len
		call	find_item
		mov	si,offset near_line
		call	find_item_value
		call	get_decimal_value
		;lodsb
		;sub	al,'0'
		mov	mouse_2,al	

	; find the MousePort item
		mov	si,offset mport_item
		mov	cx,mport_len
		call	find_item
		mov	si,offset near_line
		call	find_item_value
		call	get_decimal_value
		;lodsb
		;sub	al,'0'
		mov	mouse_1,al	

		mov	mouse_valid,1
	
	; find the VidPatch item
		mov	si,offset patch_item
		mov	cx,patch_len
		call	find_item
		mov	si,offset near_line
		call	find_item_value
		call	get_hex_byte
		mov	override,al
		
		call	free_memory
	
		pop	es
		pop	ds
		ret

;***********************************************************************

fatal_error:
		mov	ah,9		; print an error message
		mov	dx,offset fatal_msg
		push	cs
		pop	ds
		int	21h
		
		mov	ax,4c00h	; terminte program
		int	21h

;***************************************************************************

open_file:
;
; open the ini file
;
		mov	ax,3d00h
		mov	dx, offset ini_pathname
		int	21h
		jnc	of_exit
		jmp short fatal_error
of_exit:	
		mov	ini_handle,ax
		ret

close_file:
;
; close the ini file
;
		mov	ah,3eh
		mov	bx,ini_handle
		int	21h
		ret

get_file_size:
;
; get the size of the file
;
		mov	ax,4202h
		sub	cx,cx
		sub	dx,dx
		mov	bx,ini_handle
		int	21h		; returns file size in dx:ax
		jnc	gfs_cont1
		jmp short fatal_error
gfs_cont1:

	; > 64K file is too big !
		cmp	dx,0
		je	gfs_cont2
		jmp short fatal_error
gfs_cont2:		

		mov	file_size,ax

		mov	ax,4200h	; point file pointer to start of file
		sub	cx,cx
		sub	dx,dx
		mov	bx,ini_handle
		int	21h
		jnc	gfs_cont3
		jmp short fatal_error
gfs_cont3:
		ret
		
allocate_memory:
;
; allocate some memory to read the file into
;
		mov	ax,file_size
		mov	cl,4
		shr	ax,cl		; get size required in paras
		inc	ax		; add 1 to be safe
		mov	bx,ax
		mov	ah,48h
		int	21h
		jnc	am_cont1
		jmp short fatal_error
am_cont1:
		mov	file_seg,ax
		ret

free_memory:
;
; free up the memory previously allocated
;
		push	es
		mov	ah,49h
		mov	es,file_seg
		int	21h
		pop	es
		ret

read_file:
;
; read the file into memory
;
		
		mov	ah,3fh
		mov	bx,ini_handle
		mov	cx,file_size
		push	ds
		mov	ds,file_seg
		sub	dx,dx
		int	21h
		pop	ds
		jnc	rf_cont1
		jmp	fatal_error
rf_cont1:

	; put a zero at the end of the file in memory
		push	es
		mov	es,file_seg
		mov	di,file_size
		sub	al,al
		stosb
		pop	es
		ret

;***************************************************************************

next_line:
;
;	read the next line of the file into a near buffer
;

		push	ds
		push	es
		
		mov	ds,cs:file_seg
		push	cs
		pop	es
		
		mov	si,cs:buf_ptr
		mov	di,offset near_line

		mov	cx,254		; set maximum line length
nl_loop:
		lodsb			; get a byte from ds:si, inc si
		cmp	al,0dh
		je	nl_skipcrlf				
		cmp	al,0ah
		je	nl_skipcrlf
if DBCS
		push	ax
		call	dbcs_lead
		test	ax, ax
		pop	ax
		jz	not_dbcs
		cmp	cx, 1
		je	nl_just_dbcs
		dec	cx
		stosb			; store lead byte
		lodsb			; load second byte
		jmp short nl_just_dbcs
not_dbcs:
endif
		call	toupper		; upper case the character
if DBCS
nl_just_dbcs:
endif
		stosb			; store byte at es:di, inc di
		cmp	al,0
		je	nl_exit

		loop	nl_loop

		mov	al,0
		stosb
		jmp	nl_exit

nl_skipcrlf:
		lodsb
		cmp	al,0dh
		je	nl_skipcrlf
		cmp	al,0ah
		je	nl_skipcrlf
		mov	al,0
		stosb
nl_exit:
		dec	si
		mov	cs:buf_ptr,si
		pop	es
		pop	ds
		ret		
		
;***************************************************************************

toupper:
;
;	Convert the character in al to upper case
;
		cmp	al,'a'
		jb	tu_exit
		cmp	al,'z'
		ja	tu_exit
		sub	al,20h
tu_exit:
		ret
	
;***************************************************************************

find_section:
;
;	find a section heading in the file.
;	si    = address of section name string
;	cx    = length of string
;	assume cs = ds = es
	
		push	bp
		mov	bp,sp
		sub	sp,4		; make room for 2 local vars
		mov	-2[bp],si
		mov	-4[bp],cx
	
		mov	buf_ptr,0	; start at befinning of file
fs_loop:
		call	next_line	; get a line
	
		mov	ah,near_line
		cmp	ah,0
		je	fs_notfound
	
		mov	si,-2[bp]
		mov	di,offset near_line
		mov	cx,-4[bp]	
		rep	cmpsb		; check if this is the heading
		jne	fs_loop
	
		mov	ax,buf_ptr
		mov	section_ptr,ax

		add	sp,4
		pop	bp
		ret
	
fs_notfound:
		jmp	fatal_error
	
;***************************************************************************

find_item:
;
;	find an item within a section in the file.
;	si    = address of item name string
;	cx    = length of string
;	section_ptr -> start of section
;	assume cs = ds = es
	
		push	bp
		mov	bp,sp
		sub	sp,4		; make room for 2 local vars
		mov	-2[bp],si
		mov	-4[bp],cx
	
		mov	ax,section_ptr
		mov	buf_ptr,ax	; start at befinning of section
fi_loop:
		call	next_line	; get a line
	
		mov	ah,near_line
		cmp	ah,0
		je	fi_notfound
		cmp	ah,'['
		je	fi_notfound
	
		mov	si,-2[bp]
		mov	di,offset near_line
		mov	cx,-4[bp]	
		rep	cmpsb		; check if this is the item
		jne	fi_loop

		add	sp,4
		pop	bp
		ret
	
fi_notfound:
		jmp	fatal_error
	
;***************************************************************************

find_item_value:
;
; find the start of the value in the item line
; ds:si -> start of line
;
	; look for the '=' sign	
fiv_loop1:
		lodsb
		cmp	al,0
		je	fiv_err
		cmp	al,'='
		jne	fiv_loop1
	
		call	deblank	

	; skip over any quoted string
		mov	al,[si]
		cmp	al,'"'
		jne	fiv_exit
		inc	si
fiv_loop2:
		lodsb
		cmp	al,0
		je	fiv_err
		cmp	al,'"'
		jne	fiv_loop2

		call	deblank

	; skip over the comma
		mov	al,[si]
		cmp	al,','
		jne	fiv_exit
		inc	si
		call	deblank

fiv_exit:		
		ret
fiv_err:
		jmp	fatal_error

deblank:
		lodsb
		cmp	al,0
		je	fiv_err
		cmp	al,33
		jb	deblank
		dec	si
		ret
		
;***************************************************************************

get_hex_byte:
;
; convert the 2 character hex string at si to a byte value, returned in al 
;
		mov	ah,0
		mov	cl,4
		lodsb
		call	toupper
		call	hex_char
		shl	al,cl
		mov	ah,al
		lodsb
		call	toupper
		call	hex_char
		add	al,ah		
		ret

hex_char:
		cmp	al,'9'
		ja	hc_skip1
		sub	al,'0'
		ret
hc_skip1:	sub	al,'A'-10
		ret

;***************************************************************************

build_filename:
;
; generate the path to the ini file
;
		push	ds
		push	es
		
		mov	es,psp_base
	assume ds:PSP_SEG
		mov	bx,es:PSP_ENV
	assume ds:DATA
		mov	es,bx		; es -> environment

		sub	di,di
bf_loop1:
		mov	si,offset cfg_variable
		mov	cx,cfg_varlen   
		rep	cmpsb
		je	bf_found
		mov	al,0
		mov	cx,256
		repne	scasb
		mov	al,es:[di]
		cmp	al,0
		je	bf_notfound

		jmp short bf_loop1

bf_found:
	; copy the drdoscfg path to ini_pathname
		push	es
		push	di
		pop	si
		pop	ds	; ds:si -> environment string
		
		mov	di,offset ini_pathname		
		push	cs
		pop	es	; es:di -> ini_pathname
		
bf_loop2:
		lodsb		; copy it
		stosb
		cmp	al,0
		jne	bf_loop2

		jmp	bf_exit

bf_notfound:
	; get the load path of viewmax.exe
		push	es
		push	di
		pop	si
		pop	ds
		
		add	si,3	; ds:si -> loadpath which is after environment
		mov	di,offset ini_pathname
		push	cs
		pop	es
bf_loop3:
		lodsb		; copy loadpath to ini_pathname
		stosb
		cmp	al,0
		jne	bf_loop3

bf_loop4:
		dec	di	; search backwards for the last '\'
		mov	al,es:[di]
		cmp	al,'\'		
		jne	bf_loop4
		mov	al,0
		stosb		; replace it with a zero

bf_exit:
		push	cs
		pop	ds
		mov	si,offset ini_fname
		mov	di,offset ini_pathname
		call	catfname

		pop	es
		pop	ds
		ret


;***************************************************************************
catfname:
;
; put a filename on the end of a path.
; es:di -> path, ds:si -> name
;
if DBCS
		mov	dx, di		; save start of string
endif
		mov	cx,256
		mov	al,0
		repne	scasb
		sub	di,2
if DBCS
		push	si
		mov	si, di
		dec	si
		call	check_dbcs	; ds:[si] is a lead byte?
		pop	si
		test	ax, ax
		jnz	cf_just_dbcs	; skip second byte
endif
		mov	al,es:[di]
if DBCS
cf_just_dbcs:
endif
		inc	di
		cmp	al,'\'
		je	cf_loop1
		mov	al,'\'
		stosb
cf_loop1:
		lodsb
		stosb
		cmp	al,0
		jne	cf_loop1
		ret

;***************************************************************************
get_decimal_value:
;
;	get the decimal value at si, return in ax
;
		push	si
		mov	cx,0

	; skip + or - signs
gdv_loop1:	lodsb
		cmp	al,'-'
		je	gdv_loop1
		cmp	al,'+'
		je	gdv_loop1	
		dec	si		
	
	; process the decimal digits
gdv_loop2:	lodsb	
		cmp	al,33
		jb	gdv_break2
		cmp	al,'9'
		ja	gdv_err
		cmp	al,'0'
		jb	gdv_err

		sub	al,'0'
		sub	ah,ah
		mov	bx,ax
		mov	ax,cx
		mov	cx,10
		mul	cx
		add	ax,bx
		mov	cx,ax
		jmp short gdv_loop2

gdv_break2:	pop	si
		lodsb
		cmp	al,'-'
		jne	gdv_notneg
		neg	cx
gdv_notneg:	mov	ax,cx
		ret	

gdv_err:	jmp	fatal_error

;***************************************************************************
CODE	ends

		end

