;    File              : $Workfile: OVERLAY.ASM$
;
;    Description       : Starting and init code for VIEWMAX.EXE (gets overlaid)
;
;    Original Author   : ?
;
;    Last Edited By    : $Author: AWIGHTMA$
;
;-----------------------------------------------------------------------;
;       Copyright 1999, Caldera Thin Clients, Inc.                      ;
;       This software is licenced under the GNU Public License.         ;
;       Please see LICENSE.TXT for further information.                 ;
;                                                                       ;
;                  Historical Copyright                                 ;
;	Copyright (C) 1976-1992 Digital Research Inc. All rights	;
;	reserved. The Software Code contained in this listing is	;
;	proprietary to Digital Research Inc., Monterey,			;
;	California, and is covered by U.S. and other copyright		;
;	protection. Unauthorized copying, adaption, distribution,	;
;	use or display is prohibited and may be subject to civil	;
;	and criminal penalties. Disclosure to others is			;
;	prohibited. For the terms and conditions of software use,	;
;	refer to the appropriate Digital Research Licence		;
;	Agreement.							;
;-----------------------------------------------------------------------;
;
;    *** Current Edit History ***
;    *** End of Current Edit History ***
;
;    $Log: $
;    OVERLAY.ASM 1.1 92/07/23 18:07:11 AWIGHTMA
;    ; 13 Nov 91	K.H	Add CHGENV code.
;    ; 01 Dec 91	K.H	Support double byte character set.
;    ; 15 Jun 92	atw	Initialise the dbcs structure here rather than in chev
;    
;
;    ENDLOG
include	equates.inc		; contains equates, definitions and externals

		public	build_assign_table
		public	check_resident
if CHGENV
		extrn	find_app:near
else
		public	find_app
endif
		public	find_drivers
if GEM
		public	gemboot
		public	gem_directory
endif
		public	loader_code_start

		extrn	parse_command_line:near
		extrn	parse_inifile:near
		extrn	clear_ws_table_entry:near
		extrn	set_gdos_directory:near
		extrn	reset_and_exit:near
		extrn	overlay_loader:near
if CHGENV
		extrn	parse_country:near
endif
if DBCS
		extrn	dbcs_init:near
		extrn	check_dbcs:near
endif


;************************************************************************
;* loader_code_start							*
;************************************************************************
loader_code_start:

; Save the PSP segment address so the GDOS can find its FCBs later.
		mov	psp_base, es
		
		push	ds
		mov	ah, GET_DRIVE		; Remember current drive
		int	PCDOS
		mov	root_drive, al
		mov	dl,al
		inc	dl
		mov	ax, seg root_path	; Remember current path
		mov	ds, ax
		mov	si, offset root_path	; ds:si = current path string
		mov	ah, GET_DIR		; eg GEMAPPS\GEMSYS
		int	PCDOS

		push	es
	assume ds:PSP_SEG
		mov	bx,es:PSP_ENV		; Get segment of our environment
	assume ds:DATA
		mov	es,bx			; Point to start of environment
		mov	bx,0
seek_envend:
		inc	bx
		cmp	es:word ptr -1[bx],0	; Look for end of environment
		jnz	seek_envend

		inc	bx
		inc	bx			; Point to load path
		inc	bx
		mov	dl, es:byte ptr [bx]	; Get drive letter
		sub	dl,'A'			; determine drive vector
		mov	ah, SET_DRIVE
		int	PCDOS			; Change drive
		
		push	bx		; Remember start of load path
seek_loadend:
		inc	bx		; Look for end of load path
		cmp	es:byte ptr [bx],0
		jnz	seek_loadend

seek_pathend:
		dec	bx
		cmp	es:byte ptr [bx],'\'	; Trim GEMVDI.EXE from end
		jnz	seek_pathend

		cmp	es:byte ptr -1[bx],':'	; Loaded from the root?
		jnz	noroot_load		; if so dont trim the '\'
		inc	bx
noroot_load:		
		pop	dx		; Get back the start address
		mov	al,es:byte ptr [bx]
		mov	es:byte ptr [bx], 0
		push	bx		; save what we patched over
		push	ax
		push	es		; DS->environment
		pop	ds		; DX->load path
		mov	ah, SET_DIR	; Now CD to our home directory
		int	PCDOS
		pop	ax
		pop	bx
		mov	es:byte ptr [bx],al	; Fix the environment
		
		pop	es	; Get back original segment registers
		pop	ds
				
; Get the current drive and path.
		mov	ah, GET_DRIVE
		int	PCDOS
		mov	gdos_drive, al
		mov	saved_drive, al

		mov	dl, al
		inc	dl
		mov	ax, seg gdos_path
		mov	ds, ax
		mov	si, offset gdos_path + 1; ds:si = GDOS path string
		mov	ah, GET_DIR
		int	PCDOS

		mov	si, offset saved_path + 1; ds:si = saved path string
		mov	ah, GET_DIR
		int	PCDOS

		mov	si, offset app_path + 1	; ds:si = application path
		mov	ah, GET_DIR
		int	PCDOS

if DBCS
		call	dbcs_init		; initialise the dbcs structure
endif						; before any calls are made

if CHGENV
		push	es
		call	parse_country
		pop	es
endif
; Initialize the exec parameter block to indicate no command tail.  Parse
; the command line.
ini_parm_block:
		call	parse_inifile
		mov	pblock + 2, offset command_tail
		mov	pblock + 4, seg command_tail
		call	parse_command_line
		  
; Find the application.
		call	find_app

; Initialize the workstation table to zeroes.
		mov	cx, WS_ENTRIES		; cx = number of table entries
		xor	bx, bx			; bx = table index
init_table_loop:
		call	clear_ws_table_entry	; clear the table entry
		inc	bx
		inc	bx			; next index
		loop	init_table_loop

; Try to build an assignment table.  If none is built (length zero),
; report an error and exit.
		call	set_gdos_directory
		call	build_assign_table
		cmp	di, 0
		jne	lcs_calc_overlay
		mov	dx, offset no_drivers	; dx -> error string
		jmp	reset_and_exit

; Compute the ending address of the overlayable part of the GDOS and the
; driver.  This is equal to the address of the first paragraph after the
; overlay point plus the size of the assign table in paragraphs.
lcs_calc_overlay:
		mov	ax, offset loader_code_start
		mov	cl, 4
		shr	ax, cl
		add	ax, seg loader_code_start
		inc	ax
		mov	overlay_segment, ax
		mov	dx, assign_table_length
		shr	dx, cl
		inc	dx
		add	ax, dx
		mov	bx, ax
		sub	bx,psp_base
		inc	bx
		mov	prog_size, bx

; Switch the stack to the PSP and jump to the resident part of the loader.
end_overlay:
		cld
		pushf
		pop	si
		cli
		mov	ss, psp_base
		mov	sp, 0feh
		push	si
		popf
		jmp	overlay_loader

if not CHGENV
;************************************************************************
;* find_app								*
;************************************************************************
find_app:
; Set up a DTA at the end of the stack segment.
		mov	ax, STACK_SIZE
		mov	cl, 4
		shr	ax, cl
		mov	bx, ss
		add	ax, bx
		inc	ax
		mov	ds, ax
		xor	dx, dx
		mov	ah, SET_DTA
		int	PCDOS

; Does the application exist in the current directory?
		mov	ax, cs
		mov	ds, ax
		mov	dx, offset app_name
		xor	cx, cx
		mov	ah, FIND_FIRST
		int	PCDOS
if GEM
		jc	check_gem_directories
		jmp	end_find_app

; Couldn't find the application in the current directory.  Check the
; GEMBOOT driectory.

check_gem_directories:

		mov	dx, offset gemboot
		call	gem_directory
endif
		jc	traverse_search_path
		jmp	end_find_app

; Couldn't find the application in a GEM directory.  Traverse the search path.
traverse_search_path:
		mov	es, psp_base
	assume ds:PSP_SEG
		mov	es, es:PSP_ENV		; environment segment address
	assume ds:DATA
		xor	di, di			; es:di = environment address
test_envend:
		cmp	es:byte ptr [di], 0	; 1st of next string = NUL?
		je	end_find_app		; couldn't find 'PATH='
		mov	dx, di			; save start of current string
		mov	si, offset path_string	; cs=ds:si -> "PATH="
		mov	cx, cs:path_string_len	; 5
	repe	cmpsb
		jcxz	path_found		; jump if matched
		mov	di, dx			; restore to start of string
		mov	cx, 0ffffh		; try forever
		xor	al,al			; al = 0
	repne	scasb				; search for NUL, di is 1 past
		jmp short test_envend		; go check if more strings

; Found 'PATH'.  The first path name is pointed to by es:di.
path_found:
		xor	bx, bx			; done flag
path_check_loop:
		cmp	bx, 0			; done yet?
		jne	app_not_found
		mov	si, offset app_path
		mov	dx, si
		dec	si
get_path_loop:
		mov	al, es:[di]
		cmp	al, 0
		jne	check_for_semi
		inc	bx
		jmp short check_path
check_for_semi:
		inc	di
		cmp	al, ';'
		je	check_path
		inc	si
		mov	ds:[si], al
		jmp short get_path_loop

; A path name is now stored in app_path.  Concatenate the file name.
check_path:
if DBCS
		dec	si
		call	check_dbcs
		inc	si
		test	ax, ax
		jnz	cp_just_dbcs
endif
		cmp	byte ptr [si], '\'	; '\' already specified?
		je	prep_get_name_loop
if DBCS
cp_just_dbcs:
endif
		inc	si
		mov	byte ptr [si],'\'
prep_get_name_loop:
		push	si			; save for later
		push	di			; save for later
		inc	si
		mov	di, offset app_name
get_name_loop:
		mov	al, [di]
		inc	di
		mov	[si], al
		inc	si
		cmp	al, 0
		jne	get_name_loop

; Does the file exist?
		mov	ax, cs
		mov	ds, ax
		xor	cx, cx
		mov	ah, FIND_FIRST
		int	PCDOS
		pop	di			; restore environment pointer
		pop	si			; restore path end pointer
		jc	path_check_loop		; not found:  try another

; Found the file.  Tag a null at the end of the path name.  If the path name
; is something like 'C:\', make sure that the '\' is included.
		dec	si			; point to candidate ':'
		cmp	byte ptr [si], ':'
		jne	null_tag		; skip if not '?:\'
		inc	si
		mov	byte ptr [si], '\'	; concatenate '\'
null_tag:
		inc	si
		mov	byte ptr [si], 0
end_find_app:
		ret

; The application does not exist.  Output an error message and exit.
app_not_found:
		mov	dx, offset app_error
		jmp	reset_and_exit
endif

if GEM
;************************************************************************
;* gem_directory							*
;************************************************************************
gem_directory:

; Set to the requested directory.
		mov	ah, SET_DIR
		int	PCDOS
		jc	end_gem_directory

; Look for the application.
		push	dx
		mov	dx, offset app_name
		xor	cx, cx
		mov	ah, FIND_FIRST
		int	PCDOS
		pushf

; Restore the GDOS directory.
		mov	dx, offset gdos_path
		mov	ah, SET_DIR
		int	PCDOS

; If the application was found, copy the directory name.
		popf
		pop	dx
		jc	end_gem_directory
		mov	si, dx
		mov	di, offset app_path
gem_directory_loop:
		lodsb
		mov	[di], al
		inc	di
		cmp	al, 0
		jne	gem_directory_loop
		clc

end_gem_directory:
		ret
endif


;************************************************************************
;* build_assign_table							*
;*	Assignment table length returned in di.				*
;************************************************************************
build_assign_table:
		cld

; Find out where the initial copy of the assignment table should be built.
		mov	ax, STACK_SIZE/16
		mov	dx, ss
		add	ax, dx
		inc	ax			; ax = file buffer segment
		mov	dx, ax			; dx = DTA segment
		add	ax, 20
		mov	assign_seg, ax
		mov	es, ax
		xor	di, di			; ds:di -> assignment table

; Assumed state of affairs:
;	ASS_LENGTH		equ	16	; length of assignment item
;	ASS_NAME_LGTH		equ	13	; length of a file name
;	ASS_WORK_ID		equ	0	; offset to the workstation id
;	ASS_RES_ID		equ	2	; offset to reserved byte
;	ASS_FILE_NAME		equ	3	; offset to driver file name
;
;	es:di -> next write location in the assignment table.

; Set up a DTA.
		mov	cs:local_dta, dx
		mov	ds, dx
		xor	dx, dx
		mov	ah, SET_DTA
		int	PCDOS

; Find  a screen driver.
		mov	ax, cs
		mov	ds, ax
		mov	dx, offset sd_name
		xor	cx, cx
		mov	ah, FIND_FIRST
		int	PCDOS
		jnc	bat_found_screen
		mov	dx, offset no_screen
		jmp	reset_and_exit

; Found the screen driver. Save information.
bat_found_screen:
		mov	bx, di			; save start of table item
		mov	es:word ptr ASS_WORK_ID[di], 1	; screen id
		mov	ds, cs:local_dta
		mov	si, 30			; ds:si -> file name in DTA
		add	di, ASS_FILE_NAME
		mov	cx, 13			; cx = loop maximum
	rep	movsb				; copy file name
		mov	di, bx
		call	check_resident
		add	di, ASS_LENGTH
;		
if GEM ; Only look for other drivers if this is for GEM system
;
; Look for plotter drivers.
		mov	dx, offset vd_name	; cs:dx -> plotter driver name
		mov	bp, 11			; bp = plotter driver id
		call	find_drivers

; Look for printers drivers.
		mov	dx, offset pd_name	; cs:dx -> printer driver name
		mov	bp, 21			; bp = printer driver id
		call	find_drivers

; Look for metafile drivers.
		mov	dx, offset md_name	; cs:dx -> metafile name
		mov	bp, 31			; bp = metafile driver id
		call	find_drivers

; Look for camera drivers.
		mov	dx, offset cd_name	; cs:dx -> camera driver name
		mov	bp, 41			; bp = camera driver id
		call	find_drivers

; Look for scanner drivers.
		mov	dx, offset id_name	; cs:dx -> scanner driver name
		mov	bp, 61			; bp = scanner driver id
		call	find_drivers

; The table has been successfully built.  Save its length and zero out
; the last link.
endif	; if GEM
bat_table_done:
		mov	es:word ptr ASS_WORK_ID[di], 0	; zero workstation id
		add	di, 2
		mov	assign_table_length, di
		ret

;************************************************************************
;* find_drivers								*
;*	es:di -> assignment table item.					*
;*	cs:dx -> driver name						*
;*	bp = starting driver id						*
;************************************************************************
find_drivers:
		mov	ax, cs
		mov	ds, ax
		xor	cx, cx
		mov	ah, FIND_FIRST
		int	PCDOS
		jc	end_find_drivers
		mov	cx, 9			; cx = maximum driver count
		mov	ds, cs:local_dta

; Top of the driver search loop.  If the file is not really an executable
; driver, ignore it.
fd_loop:
		push	cx			; save maximum driver count
		mov	dx, 30			; ds:dx -> file name in DTA
		mov	ax, 256*FILE_OPEN
		int	PCDOS
		jc	fd_find_next
		mov	bx, ax			; bx = file handle
		mov	cx, 2			; cx = read count
		mov	dx, 48			; ds:dx -> read buffer
		mov	ah, FILE_READ
		int	PCDOS
		pushf				; save read status
		mov	ah, FILE_CLOSE
		int	PCDOS
		popf				; restore read status
		jc	fd_find_next
	assume ds:EXE_SEG
		cmp	word ptr EXE_SIG, 5a4dh	; valid EXE file signature?
	assume ds:DATA
		jne	fd_find_next

; Update the assignment table.
		mov	bx, di			; save start of table item
		mov	es:ASS_WORK_ID[di], bp	; save workstation id
		inc	bp
		mov	si, 30			; ds:si -> file name in DTA
		add	di, ASS_FILE_NAME
		mov	cx, 13			; cx = loop maximum
	rep	movsb				; copy file name
		mov	di, bx			; restore table item start
		call	check_resident
		add	di, ASS_LENGTH

; Get the next printer driver.
fd_find_next:
		pop	cx			; restore maximum driver count
		mov	ah, FIND_NEXT
		int	PCDOS			; find the next match
		jc	end_find_drivers
		loop	fd_loop

; That's all!
end_find_drivers:
		ret

;************************************************************************
;* check_resident							*
;*	es:di -> assignment table item.					*
;************************************************************************
check_resident:
		push	ds

; Bail out if no resident driver specified.
		mov	es:byte ptr ASS_RES_ID[di], 0
		cmp	resident_valid, 0
		je	end_check_resident
		mov	cl, resident_valid
		xor	ch, ch			; cx = resident length

; Look for an exact match.
		mov	ax, cs
		mov	ds, ax
		mov	si, offset rd_name	;ds:si -> resident name
		push	di
		add	di, ASS_FILE_NAME
	rep	cmpsb
		pop	di
		jne	end_check_resident
		mov	es:byte ptr ASS_RES_ID[di], 1

; That's all!
end_check_resident:
		pop	ds
		ret


;************************************************************************
;* Data area for information which can be discarded after loading.	*
;************************************************************************

if GEM
gemboot		db	'..\GEMBOOT', 0
endif
local_dta	dw	0
if not CHGENV
path_string	db	'PATH='
path_string_len	dw	5
ENDIF
if GEM
vd_name		db	'VD*.*', 0	; plotters
pd_name		db	'PD*.*', 0	; printers
md_name		db	'MD*.*', 0	; metafile
cd_name		db	'CD*.*', 0	; cameras
id_name		db	'ID*.*', 0	; scanners
endif


	db	'-------------------------------------------------', CR, LF
	db	'GEMVDI                               Version 3.0 ', CR, LF
	db	'Serial No. XXXX-0000-654321   All Rights Reserved', CR, LF
	db	'Copyright (C) 1985-1987     Digital Research Inc.', CR, LF
	db	'-------------------------------------------------', CR, LF
	db	'12/07/87'

CODE	ends
		end	loader_code_start
